IF EXISTS (SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES
         WHERE TABLE_NAME = 'sales_totals')
   DROP TABLE sales_totals
GO

CREATE TABLE sales_totals (
	[title_id] [tid] NOT NULL,
	[qty] [smallint] NOT NULL
) ON [PRIMARY]
GO

--Create a simple stored procedure that accepts two values, a title_id and a sales qty
--If it finds the title_id in the sales_totals table it will update the qty field
--else it will insert the title_id and qty as a new record

IF EXISTS (SELECT name FROM sysobjects 
         WHERE name = 'sp_add_to_sales' AND type = 'P')
   DROP PROCEDURE sp_add_to_sales
GO

CREATE PROCEDURE dbo.sp_add_to_sales (@title [tid], @qty INT) -- Note the brackets are optional
AS
BEGIN
	DECLARE @num_records INT
	SET @num_records = 
		(
		SELECT COUNT(*) FROM sales_totals
		WHERE title_id = @title
		)
IF @num_records = 1
	BEGIN
		UPDATE sales_totals
		SET qty = qty + @qty
		WHERE title_id = @title

	END
ELSE
	BEGIN
		INSERT INTO sales_totals 
		VALUES (@title, @qty)
	END
END
GO

--OK, let's try it out with a few calls to this stored proc

EXECUTE sp_add_to_sales BU1032, 3 -- Note the slightly unusual syntax of no brackets
EXECUTE sp_add_to_sales BU2075, 5
EXECUTE sp_add_to_sales TC3218, 20

SELECT * FROM sales_totals
